unit Demomain;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, Buttons, StdCtrls, Custbtn, Balloon, Dtmisc,
  VisApp;

type
  TFrontPanel = class(TForm)
    BWCCBtn: TShadowButton;
    ODBtn: TShadowButton;
    MiscBtn: TShadowButton;
    ClockBtn: TShadowButton;
    LEDBtn: TShadowButton;
    CustomHint: TCustomHint;
    BalloonHint: TBalloonHint;
    VisualApp1: TVisualApp;
    BackgroundBtn: TShadowButton;
    procedure MiscBtnClick(Sender: TObject);
    procedure BWCCBtnClick(Sender: TObject);
    procedure LEDBtnClick(Sender: TObject);
    procedure ClockBtnClick(Sender: TObject);
    procedure ODBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure VisualApp1Message(var Msg: TMsg; var Handled: Boolean);
    procedure BackgroundBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure LoadGrossBitmaps;
    procedure UnloadGrossBitmaps;
  end;

var
  FrontPanel: TFrontPanel;

implementation

{$R *.DFM}
{$IFNDEF WIN32}
{$R DTDEMO.RES}
{$ELSE}
{$R DTDEMO32.RES}
{$ENDIF}

uses
  DemoBWCC, DemoLED, DemoClok, DemoMisc, DemoDraw, DemoBack;

procedure TFrontPanel.UnloadGrossBitmaps;
begin
  BWCCBtn.Bitmap.Handle := 0;
  ODBtn.Bitmap.Handle := 0;
  MiscBtn.Bitmap.Handle := 0;
  ClockBtn.Bitmap.Handle := 0;
  LEDBtn.Bitmap.Handle := 0;
  BackgroundBtn.Bitmap.Handle := 0;
end;

procedure TFrontPanel.LoadGrossBitmaps;
begin
  BWCCBtn.Bitmap.Handle := LoadBitmap(HInstance, 'BWCC');
  ODBtn.Bitmap.Handle := LoadBitmap(HInstance, 'OWNERDRAW');
  MiscBtn.Bitmap.Handle := LoadBitmap(HInstance, 'MISC');
  ClockBtn.Bitmap.Handle := LoadBitmap(HInstance, 'CLOCK');
  LEDBtn.Bitmap.Handle := LoadBitmap(HInstance, 'LED');
  BackgroundBtn.Bitmap.Handle := LoadBitmap(HInstance, 'BACKGROUND');
end;

procedure TFrontPanel.MiscBtnClick(Sender: TObject);
begin
  MiscGadgets.ShowModal;
end;

procedure TFrontPanel.BWCCBtnClick(Sender: TObject);
begin
  BWCCControls.ShowModal;
end;

procedure TFrontPanel.LEDBtnClick(Sender: TObject);
begin
  LEDControls.ShowModal;
end;

procedure TFrontPanel.ClockBtnClick(Sender: TObject);
begin
  Clocks.ShowModal;
end;

procedure TFrontPanel.ODBtnClick(Sender: TObject);
begin
  OwnerDrawControls.ShowModal;
end;

procedure TFrontPanel.FormCreate(Sender: TObject);
begin
  BalloonHint.Active := True;
end;

procedure TFrontPanel.VisualApp1Message(var Msg: TMsg;
  var Handled: Boolean);
begin
  with Msg do
    if (message = WM_KEYDOWN) and (wParam = VK_F1) then
      Application.HelpContext(0);
end;

procedure TFrontPanel.BackgroundBtnClick(Sender: TObject);
begin
  BackgroundControls.ShowModal;
end;

end.
